/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.Messages;
import com.aptana.editor.html.contentassist.model.SpecificationElement;
import com.aptana.editor.html.contentassist.model.UserAgentElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeElement
extends BaseElement<Property> {
    private static final String USER_AGENTS_PROPERTY = "userAgents";
    private static final String SPECIFICATIONS_PROPERTY = "specifications";
    private static final String REFERENCES_PROPERTY = "references";
    private static final String VALUES_PROPERTY = "values";
    private static final String DEPRECATED_PROPERTY = "deprecated";
    private static final String REMARK_PROPERTY = "remark";
    private static final String HINT_PROPERTY = "hint";
    private static final String TYPE_PROPERTY = "type";
    private static final String ELEMENT_PROPERTY = "element";
    private String _type;
    private String _element;
    private List<SpecificationElement> _specifications;
    private List<UserAgentElement> _userAgents;
    private String _deprecated;
    private String _hint;
    private List<String> _references;
    private String _remark;
    private List<ValueElement> _values;

    public void addReference(String reference) {
        if (reference != null && reference.length() > 0) {
            if (this._references == null) {
                this._references = new ArrayList<String>();
            }
            this._references.add(reference);
        }
    }

    public void addSpecification(SpecificationElement specification) {
        if (specification != null) {
            if (this._specifications == null) {
                this._specifications = new ArrayList<SpecificationElement>();
            }
            this._specifications.add(specification);
        }
    }

    public void addUserAgent(UserAgentElement userAgent) {
        if (userAgent != null) {
            if (this._userAgents == null) {
                this._userAgents = new ArrayList<UserAgentElement>();
            }
            this._userAgents.add(userAgent);
        }
    }

    public void addValue(ValueElement value) {
        if (value != null) {
            if (this._values == null) {
                this._values = new ArrayList<ValueElement>();
            }
            this._values.add(value);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setElement(StringUtil.getStringValue(object.get(ELEMENT_PROPERTY)));
        this.setType(StringUtil.getStringValue(object.get(TYPE_PROPERTY)));
        this.setHint(StringUtil.getStringValue(object.get(HINT_PROPERTY)));
        this.setRemark(StringUtil.getStringValue(object.get(REMARK_PROPERTY)));
        this.setDeprecated(StringUtil.getStringValue(object.get(DEPRECATED_PROPERTY)));
        this._values = IndexUtil.createList(object.get(VALUES_PROPERTY), ValueElement.class);
        this._references = IndexUtil.createList(object.get(REFERENCES_PROPERTY));
        this._specifications = IndexUtil.createList(object.get(SPECIFICATIONS_PROPERTY), SpecificationElement.class);
        this._userAgents = IndexUtil.createList(object.get(USER_AGENTS_PROPERTY), UserAgentElement.class);
    }

    public String getDeprecated() {
        return StringUtil.getStringValue((Object)this._deprecated);
    }

    public String getElement() {
        return StringUtil.getStringValue((Object)this._element);
    }

    public String getHint() {
        return StringUtil.getStringValue((Object)this._hint);
    }

    public List<String> getReferences() {
        return CollectionsUtil.getListValue(this._references);
    }

    public String getRemark() {
        return StringUtil.getStringValue((Object)this._remark);
    }

    public List<SpecificationElement> getSpecifications() {
        return CollectionsUtil.getListValue(this._specifications);
    }

    public String getType() {
        return StringUtil.getStringValue((Object)this._type);
    }

    public List<UserAgentElement> getUserAgents() {
        return CollectionsUtil.getListValue(this._userAgents);
    }

    public List<ValueElement> getValues() {
        return CollectionsUtil.getListValue(this._values);
    }

    public void setDeprecated(String deprecated) {
        this._deprecated = deprecated;
    }

    public void setElement(String element) {
        this._element = element;
    }

    public void setHint(String hint) {
        this._hint = hint;
    }

    public void setRemark(String remark) {
        this._remark = remark;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(ELEMENT_PROPERTY, (Object)this.getElement());
        out.add(TYPE_PROPERTY, (Object)this.getType());
        out.add(HINT_PROPERTY, (Object)this.getHint());
        out.add(REMARK_PROPERTY, (Object)this.getRemark());
        out.add(DEPRECATED_PROPERTY, (Object)this.getDeprecated());
        out.add(VALUES_PROPERTY, this.getValues());
        out.add(REFERENCES_PROPERTY, this.getReferences());
        out.add(SPECIFICATIONS_PROPERTY, this.getSpecifications());
        out.add(USER_AGENTS_PROPERTY, this.getUserAgents());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AttributeElement)) {
            return false;
        }
        AttributeElement other = (AttributeElement)obj;
        return ObjectUtil.areEqual((Object)this._element, (Object)other._element) && ObjectUtil.areEqual((Object)this.getName(), (Object)other.getName());
    }

    public int hashCode() {
        int hash = 31 + this.getElement().hashCode();
        return hash * 31 + this.getName().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<AttributeElement>
    {
        NAME(Messages.AttributeElement_NameLabel){

            public Object getPropertyValue(AttributeElement node) {
                return node.getName();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

